/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.HashMap;
import java.util.Map;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.folding.CurlyFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.HtmlFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.JsonFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.LatexFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.LispFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.NsisFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.XmlFoldParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldParserManager
implements SyntaxConstants {
    private Map<String, FoldParser> foldParserMap = this.createFoldParserMap();
    private static final FoldParserManager INSTANCE = new FoldParserManager();

    private FoldParserManager() {
    }

    public void addFoldParserMapping(String syntaxStyle, FoldParser parser) {
        this.foldParserMap.put(syntaxStyle, parser);
    }

    private Map<String, FoldParser> createFoldParserMap() {
        HashMap<String, FoldParser> map2 = new HashMap<String, FoldParser>();
        map2.put("text/c", new CurlyFoldParser());
        map2.put("text/cpp", new CurlyFoldParser());
        map2.put("text/cs", new CurlyFoldParser());
        map2.put("text/clojure", new LispFoldParser());
        map2.put("text/css", new CurlyFoldParser());
        map2.put("text/groovy", new CurlyFoldParser());
        map2.put("text/htaccess", new XmlFoldParser());
        map2.put("text/html", new HtmlFoldParser(-1));
        map2.put("text/java", new CurlyFoldParser(true, true));
        map2.put("text/javascript", new CurlyFoldParser());
        map2.put("text/json", new JsonFoldParser());
        map2.put("text/jsp", new HtmlFoldParser(1));
        map2.put("text/latex", new LatexFoldParser());
        map2.put("text/lisp", new LispFoldParser());
        map2.put("text/mxml", new XmlFoldParser());
        map2.put("text/nsis", new NsisFoldParser());
        map2.put("text/perl", new CurlyFoldParser());
        map2.put("text/php", new HtmlFoldParser(0));
        map2.put("text/scala", new CurlyFoldParser());
        map2.put("text/xml", new XmlFoldParser());
        return map2;
    }

    public static FoldParserManager get() {
        return INSTANCE;
    }

    public FoldParser getFoldParser(String syntaxStyle) {
        return this.foldParserMap.get(syntaxStyle);
    }
}

